package gov.va.vamf.scheduling.varutility.domain;

import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class CoreSetting {
    @Id
    @XmlElement
    private String id;
    @XmlElement
    private String  typeOfCare;
    @XmlElement
    private String  patientHistoryRequired;
    @XmlElement
    private Integer patientHistoryDuration;
    @XmlElement
    @Transient
    private StopCodes stopCodes;
    @XmlElement
    private Boolean canCancel;

    @XmlElement
    private Integer submittedRequestLimit;

    @XmlElement
    @Transient
    private Integer enterpriseSubmittedRequestLimit;

    public CoreSetting() {
    }

    public CoreSetting(String id, String typeOfCare, String patientHistoryRequired, Integer patientHistoryDuration, StopCodes stopCodes, Boolean canCancel, Integer submittedRequestLimit, Integer enterpriseSubmittedRequestLimit) {
        this.id = id;
        this.typeOfCare = typeOfCare;
        this.patientHistoryRequired = patientHistoryRequired;
        this.patientHistoryDuration = patientHistoryDuration;
        this.stopCodes = stopCodes;
        this.canCancel = canCancel;
        this.submittedRequestLimit = submittedRequestLimit;
        this.enterpriseSubmittedRequestLimit = enterpriseSubmittedRequestLimit;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTypeOfCare() {
        return typeOfCare;
    }

    public void setTypeOfCare(String typeOfCare) {
        this.typeOfCare = typeOfCare;
    }

    public String getPatientHistoryRequired() {
        return patientHistoryRequired;
    }

    public void setPatientHistoryRequired(String patientHistoryRequired) {
        this.patientHistoryRequired = patientHistoryRequired;
    }

    public Integer getPatientHistoryDuration() {
        return patientHistoryDuration;
    }

    public void setPatientHistoryDuration(Integer patientHistoryDuration) {
        this.patientHistoryDuration = patientHistoryDuration;
    }

    public StopCodes getStopCodes() {
        return stopCodes;
    }

    public void setStopCodes(StopCodes stopCodes) {
        this.stopCodes = stopCodes;
    }

    public Boolean getCanCancel() {
        return canCancel;
    }

    public void setCanCancel(Boolean canCancel) {
        this.canCancel = canCancel;
    }

    public Integer getSubmittedRequestLimit() {
        return submittedRequestLimit;
    }

    public void setSubmittedRequestLimit(Integer submittedRequestLimit) {
        this.submittedRequestLimit = submittedRequestLimit;
    }

    public Integer getEnterpriseSubmittedRequestLimit() {
        return enterpriseSubmittedRequestLimit;
    }

    public void setEnterpriseSubmittedRequestLimit(Integer enterpriseSubmittedRequestLimit) {
        this.enterpriseSubmittedRequestLimit = enterpriseSubmittedRequestLimit;
    }
}
